/**
 * Перехватываем событие неудачной авторизации
 */
AS.SERVICES.unAuthorized = function () {
    portal.showMessage("Ошибка авторизации");

    //Отображаем панель ввода логина/пароля
    jQuery(".auth_panel").show();
    addHandlers();
};

/**
 * Добавлены ли уже слушатели
 */
var existHandlers = false;

/**
 * Добавление слушателей
 */
var addHandlers = function () {
    if (!existHandlers) {
        //Нажатие на кнопку войти
        jQuery(".submit_auth").on("click", function (event) {
            //Если не ввели логин или пароль выдаем ошибку
            if (jQuery(".login").val().isEmpty() || jQuery(".password").val().isEmpty()) {
                portal.showMessage("Введите логин и пароль");
                event.stopPropagation();
            } else {
                //В случае ввода заменяем значение переменных авторизации и прячем панель ввода, загружаем форму
                AS.OPTIONS.login = jQuery(".login").val();
                AS.OPTIONS.password = jQuery(".password").val();
                jQuery(".auth_panel").hide();
                portal.createPlayer();
            }
        });

        //При нажатии на панель авторизации скрывать сообщение об ошибке
        jQuery(".auth_panel").on("click", function () {
            portal.hideMessage();
        });
    }

    existHandlers = true;
};
