'use strict';


var synergyURL = "http://demoextfp.synergy.tm/Synergy/";
var tokenServiceURL = "http://demoextfp.synergy.tm/TokenService/rest/tokenService/getToken";

AS.OPTIONS.locale = "ru";
AS.OPTIONS.coreUrl = "http://demoextfp.synergy.tm/Synergy/";

var portal = {
    player: null,
    /**
     * показать сообщение об ошибке
     * @param{string} message
     */
    showMessage: function (message) {
        jQuery("#message_text").html(message);
        jQuery("#message").show();
    },
    /**
     * скрыть панель сообщений
     */
    hideMessage: function () {
        jQuery("#message").hide();
    },
    /**
     * очистить текущий проигрыватель форм
     */
    clearPlayer: function () {
        if (portal.player) {
            portal.player.destroy();
        }
        jQuery("#send_button").hide();
        portal.player = null;
    },
    /**
     * добавить новый проигрыватель форм
     */
    createPlayer: function (dataId) {

        portal.clearPlayer();
        portal.player = AS.FORMS.createPlayer();
        AS.FORMS.bus.on(AS.FORMS.EVENT_TYPE.formShow, function (event, model, view) {
            model.on(AS.FORMS.EVENT_TYPE.dataLoad, function () {

            });

            if (view.editable) {
                jQuery("#send_button").show();
                jQuery("#send_button").removeAttr('disabled', 'disabled');
            }

        });


        portal.player.view.setEditable(_.isUndefined(dataId));
        portal.player.showFormData("e0bb813a-fc15-4acc-bcf2-fd5c1ee303ef", 0, dataId);


        portal.player.view.appendTo($('#form_player_div'));

        portal.player.model.on("valueChange", function () {
            portal.hideMessage();
        });

    },

    /**
     * искать форму по указанному номеру
     */
    searchData: function () {

        var counterValue = jQuery("#search_input").val();
        AS.FORMS.ApiUtils.simpleAsyncGet("rest/api/asforms/search?formUUID=e0bb813a-fc15-4acc-bcf2-fd5c1ee303ef&search=" + encodeURIComponent(counterValue) + "&field=counter&type=exact", function (data) {

            if (data === null || !(data instanceof Array) || data.length === 0) {
                portal.showMessage("Заявка с указанным номером не найдена");
                return;
            }
            var dataId = data[0];
            portal.createPlayer(dataId);
        });
    },
    /**
     * сохранить данные, получить их, отобразить номер счетчика для дальнейшего поиска
     */
    saveData: function () {
        var errors = portal.player.model.getErrors();
        if (errors.length > 0) {
            portal.showMessage("Введите все обязательные поля");
            return;
        }

        jQuery("#send_button").attr('disabled', 'disabled');

        var counterValue = portal.player.model.getModelWithId('counter').getValue();

        AS.FORMS.ApiUtils.simpleAsyncGet("rest/api/registry/create_doc?registryID=5279da23-4cdb-4527-92f8-eb70b6983a48", function (result) {
            if (result.errorCode != 0) {
                portal.showMessage("Во время сохранения данных по форме произошли ошибки. Обратитесь к администратору");
                return;
            }
            portal.player.model.asfDataId = result.dataUUID;
            portal.player.saveFormData(function (result) {

                if (_.isUndefined(result)) {
                    portal.showMessage("Во время сохранения данных по форме произошли ошибки. Обратитесь к администратору");
                    return;
                }

                AS.FORMS.ApiUtils.simpleAsyncGet('rest/api/asforms/data/' + result, function (data) {

                    data.data.forEach(function (value) {
                        if (value.id === 'counter') {
                            counterValue = value.value;
                            portal.showMessage("Ваша заявка была принята в обработку. Номер заявки - " + counterValue);
                        }
                    });
                });
                portal.clearPlayer();
            });
        });
    }
};

$(document).ready(function () {

    jQuery.ajax({
        method: "GET",
        url: tokenServiceURL + "?url=" + synergyURL,
        success: function (data) {
            AS.OPTIONS.login = "$key";
            AS.OPTIONS.password = data;

            portal.createPlayer();
        }
    });


    jQuery(document).mouseup(function (e) {
        var container = jQuery("#message");
        if (!container.is(e.target) && container.has(e.target).length === 0) {
            container.hide();
        }
    });
});
